/*** 1.   ũƮ ***/

CREATE TABLE TB_Main03 (seq BIGINT
	, main_code UNIQUEIDENTIFIER NOT NULL 
	, date DATETIME)

INSERT INTO TB_Main03
SELECT rownum AS seq, NEWID() AS main_code
	, DATEADD(MINUTE,rownum,'2020-01-01 00:00:00.000') AS date 
FROM (SELECT ROW_NUMBER() OVER (ORDER BY a.number) AS rownum, a.number
	 FROM master..spt_values a 
	 JOIN master..spt_values b 
	 ON a.type = 'P' AND b.type = 'P' AND a.number <= 1000 AND b.number <= 1000
) a

SELECT main_code AS sub_code, CAST(seq%5326 AS INT) AS value 
INTO TB_Sub03 
FROM TB_Main03

ALTER TABLE TB_Main03 ADD CONSTRAINT PK_Main03_main_code PRIMARY KEY NONCLUSTERED(main_code) 
ALTER TABLE TB_Sub03 ADD CONSTRAINT FK_TB_Sub03 FOREIGN KEY (sub_code) 
REFERENCES TB_Main03(main_code) ON DELETE CASCADE
UPDATE STATISTICS TB_Main03(PK_Main03_main_code) WITH FULLSCAN
GO


/*** 2. [AS-IS] SQL    ȹ ***/

/* TB_Main03 ̺  Main_Code Ͽ  */
DELETE FROM TB_Main03 WHERE Main_Code = '970A8E62-2F25-4D14-B167-F049BBA42620'
GO

/*** 6. [TO-BE]   ***/

--[seq] ÷  ű ε 
--ε   
CREATE INDEX NIDX01_Sub03 ON TB_Sub03(sub_code) 
GO

--SQL 
/* TB_Main03 ̺  Main_Code Ͽ  */
DELETE FROM TB_Main03 WHERE Main_Code = 'B2AF8B45-A54C-439F-A99D-6138090FCB0A'
GO